/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;      // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 mouse;      // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 resolution; // Replaced for VGHD by defines above. TheEmu.

const float pi = 3.14159265359;

vec4 colours[8];

vec3 interpColours (in vec3 orig, in vec3 target, in float t)
{

	return vec3(orig.x + (target.x - orig.x)*t, 
	    	orig.y + (target.y - orig.y)*t,
	    	orig.z + (target.z - orig.z)*t);
}

float cosEase (in float angle, in float resolution, in float offset)
{
	return (1.-(0.5-((1.+cos(angle*resolution+offset*pi+mouse.x*100.0))/2.)));
}

float deformCircle (in float angle, in float deformationAmount, in float phase)
{
	return cosEase(angle,4.,phase)*deformationAmount + 1.-deformationAmount;
}

void main( void ) {
	colours[0] = vec4 (vec3(255.,155.,69.) / 255.0, 0.5);
	colours[1] = vec4 (vec3(225.,214.,66.) / 255.0, 1.0);
	colours[2] = vec4 (vec3(63.,179.,163.) / 255.0, 1.0);
	colours[3] = vec4 (vec3(56.,127.,184.) / 255.0, 1.0);
	colours[4] = vec4 (vec3(37.,84.,163.) / 255.0, 1.0);
	colours[5] = vec4 (vec3(101.,86.,163.) / 255.0, 1.0);
	colours[6] = vec4 (vec3(178.,87.,159.) / 255.0, 1.0);
	colours[7] = vec4 (vec3(238.,75.,93.) / 255.0, 1.0);
	vec2 position = ( scaled_gl_FragCoord.xy / min (resolution.x, resolution.y) ) * 2.0 - 1.0;
	vec2 mappedMouse = mouse * 2.0 - 1.0;
	position.x -=  (resolution.x / resolution.y)*0.5;
//	position.y -= mappedMouse.y;
	float a = atan (position.x, position.y);
	float r = length (position);
        vec3 col = vec3(0.);
	float grad = abs(a) / pi;
	float edgeLim = 0.8+abs(sin(time*0.3))*0.05;
	float innerEdge = edgeLim - 0.1;
	for (int i=0; i<8; i++)
	{
		//edgeLim += sin(time*float(i)/4.);
		float phase = time*float(i)*0.3;
		vec3 rc;
		if(float(i)==7.)
		{
			rc = interpColours(colours[i].xyz,colours[0].xyz,grad);

		}
		else
		{
			rc = interpColours(colours[i].xyz,colours[i+1].xyz,grad);
		}
		
		float edge = deformCircle (a, 0.2, phase) * edgeLim;
		float inEdge = deformCircle (a, 0.1, phase) * innerEdge;
		col += clamp(float(r < edge) * (smoothstep (r, edge, edge-0.01)),0.,1.) * rc;
		col -= clamp(float(r < inEdge && r < edge) * (smoothstep (r, inEdge, inEdge-0.01)),0.,1.) * rc;
		edgeLim = innerEdge;
		innerEdge = edgeLim - 0.1;
	}
	
	
	
	gl_FragColor = vec4( col, 1.0 );
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15
	
}